Rem
Rem $Header: create_georaster_table.sql 12-mar-2007.07:13:44 zzhang Exp $
Rem
Rem create_georaster_table.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      create_georaster_table.sql 
Rem
Rem    DESCRIPTION
Rem      Preparation for GeoRaster object operations
Rem
Rem    NOTES
Rem      It also functions as the initial setup for all following demos
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    zzhang      03/12/07 - remove createDMLTrigger
Rem    wexu        08/05/04 - connect as scott 
Rem    qxie        02/18/04 - comments on RDT 
Rem    qxie        07/22/03 - automate DML trigger
Rem    qxie        02/24/03 - echo and timing on
Rem    qxie        11/11/02 - activate trigger
Rem    qxie        10/31/02 - qxie_demo1
Rem    qxie        10/24/02 - Created
Rem

-------------------------------------------------------------------
-- connect as scott/tiger for all demos
-------------------------------------------------------------------

connect scott/tiger;

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 100
SET PAGESIZE 10000
SET SERVEROUTPUT ON SIZE 5000
SET LONG 20000
SET TIMING ON
call dbms_java.set_output(5000);


-------------------------------------------------------------------
-- 1. create a georaster table
--
-- A georaster table is a table which has a column of
-- SDO_GEORASTER object type.
-------------------------------------------------------------------

drop table georaster_table purge;
create table georaster_table
    (georid     number primary key, 
     type       varchar2(32), 
     georaster  mdsys.sdo_georaster);


-------------------------------------------------------------------
-- 2. create the GeoRaster DML trigger on all georaster tables
--
-- From 11, this call is not necessary here, because GeoRaster can automatically
-- generate DMLTrigger for each georaster column. It is only needed in some 
-- specific circumstances, for detail check document.
-- 
-------------------------------------------------------------------

--call sdo_geor_utl.createDMLTrigger('georaster_table', 'georaster');


-------------------------------------------------------------------
-- 3. create RDT tables - Raster Data Tables
--
-- They store cell data of GeoRaster objects.
-- Users MUST create the RDT tables.
-- The name of a RDT must be unique. 
-- The primary key MUST be added to the RDT.
-- If the RDT table doesn't exist, the GeoRaster procedures or 
-- functions will NOT generate it automatically.
-- For huge GeoRaster objects, some tuning and setup on those
-- tables can improve the scalability and performance significantly.
-- In those cases, create the RDTs with more parameters.
-------------------------------------------------------------------

drop table st_rdt_1 purge;
drop table st_rdt_2 purge;
drop table st_rdt_3 purge;
drop table st_rdt_4 purge;

create table st_rdt_1 of mdsys.sdo_raster 
  (primary key (rasterId, pyramidLevel, bandBlockNumber,
                rowBlockNumber, columnBlockNumber))
  lob(rasterblock) store as (nocache nologging);

create table st_rdt_2 of mdsys.sdo_raster
  (primary key (rasterId, pyramidLevel, bandBlockNumber,
                rowBlockNumber, columnBlockNumber))
  lob(rasterblock) store as (nocache nologging);

create table st_rdt_3 of mdsys.sdo_raster
  (primary key (rasterId, pyramidLevel, bandBlockNumber,
                rowBlockNumber, columnBlockNumber));

create table st_rdt_4 of mdsys.sdo_raster
  (primary key (rasterId, pyramidLevel, bandBlockNumber,
                rowBlockNumber, columnBlockNumber))
  nologging
  lob(rasterblock) store as (nocache nologging pctversion 0);

commit;









